/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLKEYBOARD
#define WAYLANDBACKEND_WLKEYBOARD 1

#include <wayland-client.h>

namespace WaylandBackend
{

class WLKeyboard
{
public:
    WLKeyboard(struct wl_seat *wlSeat, struct wl_event_queue *eventQ);
    virtual ~WLKeyboard();

    void clearIfFocusMatches(struct wl_surface *wlSurface);
    
    private:

    struct wl_keyboard* _wlKeyboard;
    struct wl_seat*     _wlSeat;
    struct wl_surface   *_keyboardFocus;

    static const struct wl_keyboard_listener _keyboardListener;
    static void keyboardHandleEnter(void* data, struct wl_keyboard* keyboard,
                                  uint32_t serial, struct wl_surface* surface,
                                  struct wl_array* keys);

    static void keyboardHandleKeymap(void* data, struct wl_keyboard* keyboard,
                                     uint32_t format, int fd, uint32_t size);

    static void keyboardHandleModifiers(void* data, struct wl_keyboard* keyboard,
                                  uint32_t serial, uint32_t mods_depressed,
                                  uint32_t mods_latched, uint32_t mods_locked,
                                  uint32_t group);

    static void keyboardHandleKey(void* data, struct wl_keyboard* keyboard,
                                  uint32_t serial, uint32_t time, uint32_t key,
                                  uint32_t state_w);

    static void keyboardHandleLeave(void* data, struct wl_keyboard* keyboard,
                                  uint32_t serial, struct wl_surface* surface);
                                  
    static void keyboardHandleRepeatInfo(void* data, struct wl_keyboard* keyboard,
                                         int32_t rate, int32_t delay);

};

}

#endif
